<?php

// Verificăm dacă formularul a fost trimis corect
if (!isset($_POST['submit'])) {
    echo "Eroare: Formularul nu a fost trimis corect!";
    exit;
}

$name = trim($_POST['name']);
$visitor_email = trim($_POST['email']);
$phone = trim($_POST['phone']);
$terms = isset($_POST['terms']) ? "Da" : "Nu";

// Validare câmpuri obligatorii
if (empty($name) || empty($visitor_email)) {
    echo "Nume și email sunt obligatorii!";
    exit;
}

// Verificare email injection
if (IsInjected($visitor_email)) {
    echo "Email invalid!";
    exit;
}

$email_from = 'contact@stiribacau.ro';
$email_subject = "Înscriere nouă - Sportul pentru toți";

$message  = "O nouă înscriere a fost trimisă:\n\n";
$message .= "Nume: $name\n";
$message .= "Email: $visitor_email\n";
$message .= "Telefon: $phone\n";
$message .= "A acceptat termenii: $terms\n";

// FIȘIER UPLOAD
if (isset($_FILES['fileupload']) && $_FILES['fileupload']['error'] == 0) {

    $allowed_ext = ['pdf', 'doc', 'docx'];
    $file_name = $_FILES['fileupload']['name'];
    $file_tmp = $_FILES['fileupload']['tmp_name'];
    $file_size = $_FILES['fileupload']['size'];
    $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

    if (!in_array($file_ext, $allowed_ext)) {
        echo "Fișier neacceptat!";
        exit;
    }

    if ($file_size > 20971520) { // 20MB
        echo "Fișierul este prea mare (max 20MB)!";
        exit;
    }

    // Creăm folderul dacă nu există
    if (!file_exists('upload_files')) {
        mkdir('upload_files', 0755, true);
    }

    // Evităm suprascrierea
    $final_name = preg_replace('`[^a-z0-9-_.]`i', '', $file_name);
    $counter = 1;
    while (file_exists("upload_files/$final_name")) {
        $final_name = $counter++ . "_" . $final_name;
    }

    move_uploaded_file($file_tmp, "upload_files/$final_name");

    $message .= "Document încărcat: http://stiribacau.ro/html/upload_files/$final_name\n";

} else {
    $message .= "Nu a fost încărcat niciun document.\n";
}

// Trimitem email către admin
$to = "contact@stiribacau.ro";
$headers = "From: Formular CSM Bacău <noreply@stiribacau.ro>\r\n";
$headers .= "Reply-To: $visitor_email\r\n";

mail($to, $email_subject, $message, $headers);

// Trimitem email către utilizator
$user_subject = "Confirmare înscriere";
$user_headers = "From: CSM Bacău <noreply@stiribacau.ro>\r\n";
$user_message = "Bună, $name!\n\nÎți mulțumim pentru înscriere.\n\nRezumatul înscrierii:\n\n$message";

mail($visitor_email, $user_subject, $user_message, $user_headers);

// Redirect către pagina de succes
header("Location: multumesc.html");
exit;


// FUNCȚIE PROTECȚIE EMAIL INJECTION
function IsInjected($str)
{
    $injections = array('(\n+)', '(\r+)', '(\t+)', '(%0A+)', '(%0D+)', '(%08+)', '(%09+)');
    $inject = "/" . join('|', $injections) . "/i";

    return preg_match($inject, $str);
}

?>
